<?php
$alliance_slider_sc = alliance_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $alliance_slider_sc ) && strpos( $alliance_slider_sc, '[' ) !== false && strpos( $alliance_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( alliance_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$alliance_anchor_icon = alliance_get_theme_option( 'front_page_title_anchor_icon' );
		$alliance_anchor_text = alliance_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $alliance_anchor_icon ) || ! empty( $alliance_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $alliance_anchor_icon ) ? ' icon="' . esc_attr( $alliance_anchor_icon ) . '"' : '' )
									. ( ! empty( $alliance_anchor_text ) ? ' title="' . esc_attr( $alliance_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $alliance_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$alliance_scheme = alliance_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $alliance_scheme ) && ! alliance_is_inherit( $alliance_scheme ) ) {
			echo ' scheme_' . esc_attr( $alliance_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( alliance_get_theme_option( 'front_page_title_paddings' ) );
		if ( alliance_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$alliance_css      = '';
		$alliance_bg_image = alliance_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $alliance_bg_image ) ) {
			$alliance_css .= 'background-image: url(' . esc_url( alliance_get_attachment_url( $alliance_bg_image ) ) . ');';
		}
		if ( ! empty( $alliance_css ) ) {
			echo ' style="' . esc_attr( $alliance_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$alliance_anchor_icon = alliance_get_theme_option( 'front_page_title_anchor_icon' );
		$alliance_anchor_text = alliance_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $alliance_anchor_icon ) || ! empty( $alliance_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $alliance_anchor_icon ) ? ' icon="' . esc_attr( $alliance_anchor_icon ) . '"' : '' )
									. ( ! empty( $alliance_anchor_text ) ? ' title="' . esc_attr( $alliance_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( alliance_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' alliance-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$alliance_css      = '';
			$alliance_bg_mask  = alliance_get_theme_option( 'front_page_title_bg_mask' );
			$alliance_bg_color_type = alliance_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $alliance_bg_color_type ) {
				$alliance_bg_color = alliance_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $alliance_bg_color_type ) {
				$alliance_bg_color = alliance_get_scheme_color( 'bg_color', $alliance_scheme );
			} else {
				$alliance_bg_color = '';
			}
			if ( ! empty( $alliance_bg_color ) && $alliance_bg_mask > 0 ) {
				$alliance_css .= 'background-color: ' . esc_attr(
					1 == $alliance_bg_mask ? $alliance_bg_color : alliance_hex2rgba( $alliance_bg_color, $alliance_bg_mask )
				) . ';';
			}
			if ( ! empty( $alliance_css ) ) {
				echo ' style="' . esc_attr( $alliance_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$alliance_caption = alliance_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $alliance_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $alliance_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $alliance_caption, 'alliance_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$alliance_description = alliance_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $alliance_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $alliance_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $alliance_description ), 'alliance_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( alliance_get_theme_option( 'front_page_title_button1_link' ) != '' || alliance_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						alliance_show_layout( alliance_customizer_partial_refresh_front_page_title_button1_link() );
						alliance_show_layout( alliance_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
